# 機能設計書 55-Daemon プロバイダー

## 概要

本ドキュメントは、Horse WebフレームワークにおけるDaemon（デーモン）プロバイダー機能の設計を記述する。

### 本機能の処理概要

Daemon プロバイダーは、Linux/Unix環境でバックグラウンドサービス（デーモン）としてHorseアプリケーションを動作させるための機能を提供する。プロセスのデーモン化、シグナルハンドリング、syslogへのログ出力など、Unix系OSのデーモンプロセスに必要な機能を実装している。DelphiおよびFree Pascal/Lazarus両方の環境で動作可能。

**業務上の目的・背景**：Linux/Unix環境でWebアプリケーションをシステムサービスとして運用する需要がある。Daemon プロバイダーにより、適切なプロセスデーモン化（ダブルフォーク）、シグナル処理（SIGTERM/SIGHUP）、syslog連携を実現し、systemdやinit.dと連携したサービス管理が可能になる。

**機能の利用シーン**：
- Linux/Unixサーバーでのバックグラウンドサービスとしての運用
- systemd/init.d によるサービス管理が必要な場合
- syslog によるログ管理が必要な場合
- ターミナルから切り離されたデーモンプロセスとして動作させたい場合

**主要な処理内容**：
1. プロセスのデーモン化（ダブルフォーク、セッション作成、chdir、umask設定）
2. シグナルハンドリング（SIGTERM: 終了、SIGHUP: 設定再読み込み）
3. syslogへのログ出力
4. TIdHTTPWebBrokerBridge（Delphi版）/ TFPHTTPServer（FPC版）を使用したHTTPサーバー
5. SSL/TLS暗号化通信のサポート（Delphi版）
6. サーバーの起動（Listen）と停止（StopListen）処理
7. TEventによるサーバー実行状態の制御

**関連システム・外部連携**：
- POSIX シグナル（SIGTERM, SIGHUP, SIGCHLD）
- syslog ファシリティ（LOG_DAEMON）
- Indy（TIdHTTPWebBrokerBridge）ライブラリ（Delphi版）
- FPC HTTP Server（TFPHTTPServer）（FPC版）
- OpenSSL ライブラリによるSSL/TLS暗号化（Delphi版）

**権限による制御**：Daemon プロバイダー自体には権限制御機能はなく、HTTPサーバーとしてリクエストを受け付ける。認証・認可はミドルウェアやルートハンドラで実装する必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | デーモンメイン | 主機能 | DataModuleStart時にサーバー起動、DataModuleShutDown時に停止 |
| 6 | デーモンマネージャー | 主機能 | TDaemonMapperを継承しデーモンサービスの設定・管理 |

## 機能種別

サーバー管理 / デーモンプロセス実行基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Port | Integer | No | リスニングポート番号 | 0より大きい整数、デフォルト9000 |
| Host | string | No | バインドするホスト | 空文字列の場合は'0.0.0.0' |
| MaxConnections | Integer | No | 最大同時接続数（Delphi版） | 0より大きい場合に設定 |
| ListenQueue | Integer | No | リッスンキューサイズ | 0の場合デフォルト値使用 |
| KeepConnectionAlive | Boolean | No | キープアライブ設定（Delphi版） | デフォルトTrue |
| IOHandleSSL | IHorseProviderIOHandleSSL | No | SSL/TLS設定（Delphi版） | nilの場合SSL無効 |
| CallbackListen | TProc | No | 起動時コールバック | - |
| CallbackStopListen | TProc | No | 停止時コールバック | - |

### 入力データソース

- プログラムからのプロパティ設定
- Listen メソッドの引数
- POSIXシグナル（SIGTERM, SIGHUP）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IsRunning | Boolean | サーバーの実行状態（FPC版） |
| syslogメッセージ | - | デーモン状態のログ出力（Delphi版） |

### 出力先

- Boolean戻り値によるサーバー状態の返却
- syslogへのログ出力（Delphi版）
- コールバック関数の実行

## 処理フロー

### 処理シーケンス（Delphi版）

```
1. Listen メソッド呼び出し
   └─ InternalListen を呼び出す
2. イベントオブジェクト作成
   └─ TEvent.Create でサーバー制御用イベント作成
3. syslog 初期化
   └─ openlog(nil, LOG_PID or LOG_NDELAY, LOG_DAEMON)
4. デーモン化処理（親プロセスの場合）
   └─ fork() で子プロセス作成
   └─ setsid() で新セッション作成
   └─ シグナルハンドラ設定（SIGCHLD, SIGHUP, SIGTERM）
   └─ 再度 fork() でデーモンプロセス作成
   └─ 標準入出力を /dev/null にリダイレクト
   └─ umask(027) 設定
   └─ chdir('/') でルートディレクトリに移動
5. HTTPサーバー設定
   └─ GetDefaultHTTPWebBroker で TIdHTTPWebBrokerBridge 取得
   └─ WebModuleClass 設定
   └─ MaxConnections, ListenQueue, SSL設定
   └─ Bindings 設定
6. サーバー起動
   └─ Active を True に設定
   └─ StartListening 呼び出し
   └─ syslog で起動ログ出力
7. メインループ
   └─ FRunning が True の間、FEvent.WaitFor() で待機
8. 終了処理
   └─ syslog で終了ログ出力
   └─ closelog() 呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[Listen 呼び出し] --> B[TEvent.Create]
    B --> C[openlog]
    C --> D{getppid > 1?}
    D -->|Yes| E[fork - 1回目]
    D -->|No| K[HTTPサーバー設定]
    E --> F{FPID > 0?}
    F -->|Yes| G[Halt - 親プロセス終了]
    F -->|No| H[setsid]
    H --> I[シグナルハンドラ設定]
    I --> J[fork - 2回目]
    J --> K
    K --> L[WebModuleClass設定]
    L --> M[SSL設定]
    M --> N[Bindings設定]
    N --> O[Active = True]
    O --> P[StartListening]
    P --> Q[syslog - 起動ログ]
    Q --> R{FRunning?}
    R -->|Yes| S[FEvent.WaitFor]
    S --> R
    R -->|No| T[syslog - 終了ログ]
    T --> U[closelog]
    U --> V[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-01 | デフォルトポート | ポート未指定時は9000を使用 | Port が 0以下の場合 |
| BR-55-02 | デフォルトホスト | ホスト未指定時は'0.0.0.0'を使用 | Host が空文字列の場合 |
| BR-55-03 | ダブルフォーク | デーモン化時に2回forkを実行 | getppid() > 1 の場合 |
| BR-55-04 | SIGTERMハンドリング | SIGTERM受信時にFRunning=Falseにして終了 | シグナル受信時 |
| BR-55-05 | SIGHUPハンドリング | SIGHUP受信時に設定再読み込みログを出力 | シグナル受信時 |
| BR-55-06 | キープアライブ初期値 | 初期化時にKeepConnectionAliveをTrueに設定（Delphi版） | ユニット初期化時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | fork失敗 | 'Error forking the process' メッセージで例外発生 |
| - | Exception | setsid失敗 | 'Impossible to create an independent session' メッセージで例外発生 |
| - | Exception | StopListen時にHTTPWebBrokerが未生成 | 'Horse not listen' メッセージで例外発生 |
| EXIT_FAILURE | 終了コード | 例外発生時 | ExitCode = 1 |
| EXIT_SUCCESS | 終了コード | 正常終了時 | ExitCode = 0 |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

HTTPサーバーとして動作するため、データベーストランザクションは本機能では管理しない。

## パフォーマンス要件

- MaxConnections でリソース制限が可能（Delphi版）
- ListenQueue でバックログキューサイズを調整可能
- KeepConnectionAlive で持続的接続によるオーバーヘッド軽減（Delphi版）

## セキュリティ考慮事項

- IOHandleSSL プロパティでSSL/TLS暗号化を有効化可能（Delphi版）
- umask(027) でファイル作成時のパーミッション制限
- chdir('/') でカレントディレクトリをルートに変更
- 標準入出力を /dev/null にリダイレクトしてセキュリティ向上

## 備考

- HORSE_DAEMON コンパイルディレクティブが定義されている必要がある
- Delphi版とFPC/Lazarus版で実装が異なる
- Delphi版はPOSIXデーモン化処理を含む
- FPC版はTThreadを使用したシンプルな実装
- syslog連携はDelphi版のみ（ThirdParty.Posix.Syslog使用）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Daemon プロバイダーの設定に使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Constants.pas | `src/Horse.Constants.pas` | DEFAULT_HOST, DEFAULT_PORT, START_RUNNING などの定数定義 |
| 1-2 | Horse.Provider.IOHandleSSL.Contract.pas | `src/Horse.Provider.IOHandleSSL.Contract.pas` | IHorseProviderIOHandleSSL インターフェース定義 |
| 1-3 | ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | syslog関連の定義（Delphi版） |

**読解のコツ**: Daemon プロバイダーはPOSIX APIを多用する。fork、setsid、umask、chdir、signalなどのUnixシステムコールの知識が役立つ。

#### Step 2: 抽象プロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | THorseProviderAbstract クラスの定義 |

#### Step 3: Delphi版Daemonプロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | THorseProvider クラスの実装（Delphi版） |

**主要処理フロー**:
- **5行目**: `{$IF DEFINED(HORSE_DAEMON) AND NOT DEFINED(FPC)}` - Delphi専用条件コンパイル
- **66-74行目**: グローバル変数定義（FEvent, FRunning, FPID, FId, EXIT_FAILURE, EXIT_SUCCESS）
- **76行目**: HandleSignals プロシージャ宣言
- **93-106行目**: HandleSignals 実装 - シグナルハンドリング
  - 96-100行目: SIGTERM処理 - FRunning=False、FEvent.SetEvent
  - 101-104行目: SIGHUP処理 - 設定再読み込みログ出力
- **195-280行目**: InternalListen - デーモン化とサーバー起動
  - 201行目: TEvent.Create
  - 203行目: openlog - syslog初期化
  - 204-228行目: デーモン化処理（ダブルフォーク）
  - 206-210行目: 1回目のfork
  - 211-220行目: setsid、シグナルハンドラ設定、2回目のfork
  - 221-227行目: 標準入出力クローズ、/dev/nullへのリダイレクト、umask、chdir
  - 234-257行目: HTTPサーバー設定と起動
  - 265-266行目: メインループ - FEvent.WaitFor()
  - 275-276行目: syslog終了、closelog

#### Step 4: FPC/Lazarus版Daemonプロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Provider.FPC.Daemon.pas | `src/Horse.Provider.FPC.Daemon.pas` | THorseProvider クラスの実装（FPC版） |

**主要処理フロー**:
- **9行目**: `{$IF DEFINED(HORSE_DAEMON) AND DEFINED(FPC)}` - FPC専用条件コンパイル
- **25-43行目**: THTTPServerThread クラス定義
- **133-151行目**: InternalListen - サーバー起動
- **214-239行目**: OnRequest - リクエスト処理
- **241-257行目**: THTTPServerThread コンストラクタ
- **271-284行目**: Execute - スレッド実行ループ

#### Step 5: 使用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | daemonmain.pas | `samples/lazarus/winsvc/daemonmain.pas` | Lazarus版デーモン使用例 |
| 5-2 | daemonmanager.pas | `samples/lazarus/winsvc/daemonmanager.pas` | デーモンマネージャー設定 |

**主要処理フロー**:
- **43-46行目**: DataModuleCreate - ルート登録
- **53-56行目**: DataModuleStart - 別スレッドでTHorse.Listen起動
- **48-51行目**: DataModuleShutDown - THorse.StopListen呼び出し

### プログラム呼び出し階層図

```
THorse (Horse.pas)
    │
    └─ THorseProvider (Horse.Provider.Daemon.pas / Horse.Provider.FPC.Daemon.pas)
           │
           ├─ Listen()
           │      └─ InternalListen()
           │             │
           │             ├─ [Delphi版]
           │             │      ├─ TEvent.Create()
           │             │      ├─ openlog()
           │             │      ├─ fork() [1回目]
           │             │      ├─ setsid()
           │             │      ├─ Signal(SIGCHLD/SIGHUP/SIGTERM, HandleSignals)
           │             │      ├─ fork() [2回目]
           │             │      ├─ 標準入出力リダイレクト
           │             │      ├─ umask(027) / chdir('/')
           │             │      ├─ GetDefaultHTTPWebBroker()
           │             │      ├─ StartListening()
           │             │      ├─ Syslog(LOG_INFO, START_RUNNING)
           │             │      └─ FEvent.WaitFor() [メインループ]
           │             │
           │             └─ [FPC版]
           │                    ├─ GetDefaultHTTPServerThread()
           │                    │      └─ THTTPServerThread.Create()
           │                    └─ StartServer()
           │
           ├─ StopListen()
           │      └─ InternalStopListen()
           │             ├─ StopListening() / Active := False
           │             ├─ DoOnStopListen()
           │             └─ FEvent.SetEvent() [Delphi版]
           │
           └─ HandleSignals(SigNum) [Delphi版]
                  ├─ SIGTERM → FRunning := False; FEvent.SetEvent
                  └─ SIGHUP → Syslog(LOG_NOTICE, 'reloading config')
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Host/Port/               ┌─────────────────────────┐
MaxConnections  ───────▶ │   THorseProvider        │
IOHandleSSL              │   (設定保持)            │
                         └───────────┬─────────────┘
                                     │
                                     ▼
                         ┌─────────────────────────┐
  Listen()       ───────▶│ デーモン化処理          │───────▶ デーモンプロセス
                         │ (fork/setsid/umask)     │
                         └───────────┬─────────────┘
                                     │
                                     ▼
                         ┌─────────────────────────┐
  HTTPリクエスト ───────▶│   HTTPサーバー          │───────▶ HTTPレスポンス
                         │ (TIdHTTPWebBrokerBridge │         syslogログ
                         │  / TFPHTTPServer)       │
                         └───────────┬─────────────┘
                                     │
                                     ▼
  POSIXシグナル  ───────▶┌─────────────────────────┐
  (SIGTERM/SIGHUP)       │   HandleSignals         │───────▶ プロセス終了
                         │   (シグナルハンドラ)    │         設定再読み込み
                         └─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.pas | `src/Horse.pas` | ソース | メインユニット、コンパイルディレクティブによるプロバイダー選択 |
| Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | ソース | Daemon プロバイダー実装（Delphi版） |
| Horse.Provider.FPC.Daemon.pas | `src/Horse.Provider.FPC.Daemon.pas` | ソース | Daemon プロバイダー実装（FPC版） |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー抽象基底クラス |
| Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | ソース | SSL/TLS設定実装 |
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | 定数定義 |
| ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | ソース | syslog関連定義 |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | WebModuleクラス |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | コア機能（ルーティング等） |
| Daemon.dpr | `samples/delphi/daemon/Daemon.dpr` | プロジェクト | Daemonサンプルプロジェクト（Delphi） |
| daemon.lpr | `samples/lazarus/daemon/daemon.lpr` | プロジェクト | Daemonサンプルプロジェクト（Lazarus） |
| daemonmain.pas | `samples/lazarus/winsvc/daemonmain.pas` | サンプル | デーモンメイン実装 |
| daemonmanager.pas | `samples/lazarus/winsvc/daemonmanager.pas` | サンプル | デーモンマネージャー実装 |
